@extends('layouts.main')

@section('style')
<style type="text/css">
        html {
            max-width: 960px;
            margin: 0 auto
        }

        * {
            font-family: Regular
        }

        .Bold {
            font-weight: 700
        }

        .Regular {
            font-weight: 400
        }

        .innerBox90 {
            width: 90%;
            margin: auto
        }

        .colorBule {
            color: #3280f6
        }

        .radius30 {
            border-radius: 16px;
            overflow: hidden
        }

        .radius20 {
            border-radius: 10px;
            overflow: hidden
        }

        uni-toast {
            z-index: 999999
        }

        .redTxt {
            color: #e92a2a
        }

        .blueTxt {
            color: #5b99fe
        }

        .grayTxt {
            color: #2d3132
        }

        .call-us {
            width: 80px;
            height: 32px;
            background-color: pink;
            border-radius: 25px 25px 25px 25px;
            font-size: 12px;
            font-weight: 600;
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: center
        }

        .call-us uni-image {
            width: 17px;
            height: 17px;
            margin-right: 3px
        }

        .logins {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            color: #2d3132;
            background: url(/public/static/page.png) no-repeat top #000;
            background-size: 100% auto;
            padding-bottom: constant(safe-area-inset-bottom);
            /* // 兼容 IOS<11.2 */
            padding-bottom: env(safe-area-inset-bottom)
                /* // 兼容 IOS>11.2 */
        }

        .pages {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            color: #2d3132;
            background: url(/public/static/bgi.png) no-repeat top #000;
            background-size: 100% auto;
            padding-bottom: constant(safe-area-inset-bottom);
            /* // 兼容 IOS<11.2 */
            padding-bottom: env(safe-area-inset-bottom)
                /* // 兼容 IOS>11.2 */
        }

        .noData {
            text-align: center;
            color: #fff;
            width: 100%;
            font-size: 13px;
            margin-top: 53px;
            margin: auto;
            zoom: .8
        }

        .status_bar {
            width: 100%;
            height: 94px
        }

        .tab_bar {
            width: 100%;
            height: 96px
        }

        .buttons {
            width: 345px;
            height: 48px;
            background: #257cff;
            border: 1px solid #fff;
            border-radius: 32px 32px 32px 32px;
            margin: 10px auto;
            line-height: 48px;
            font-weight: 600;
            font-size: 19px;
            color: #fff;
            text-align: center
        }

        .unButtons {
            opacity: .8;
            pointer-events: none
        }

        .uni-tabbar {
            padding-bottom: 16px !important
        }

        .auto80 {
            margin: auto;
            width: 339px
        }

        .auto90 {
            margin: auto;
            width: 371px
        }

        .flexAround {
            display: flex;
            justify-content: space-around;
            align-items: center
        }

        .flexBetween {
            display: flex;
            justify-content: space-between;
            align-items: center
        }

        .flexStart {
            display: flex;
            justify-content: flex-start;
            align-items: center
        }

        .flexWrap {
            flex-wrap: wrap
        }

        .flexColumn {
            flex-direction: column;
            white-space: nowrap
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .bar[data-v-40bdd376] {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            z-index: 2
        }

        .black .title[data-v-40bdd376],
        .black .back[data-v-40bdd376] {
            color: #23427b
        }

        .white .title[data-v-40bdd376],
        .white .back[data-v-40bdd376] {
            color: #fff
        }

        .status_bars[data-v-40bdd376] {
            width: 100%;
            height: 47px;
            line-height: 47px
        }

        .backBar[data-v-40bdd376] {
            width: 371px;
            margin-left: 16px
        }

        .backBar .lineBox[data-v-40bdd376] {
            width: 100%;
            height: 47px;
            line-height: 47px
        }

        .backBar .lineBox .back[data-v-40bdd376] {
            width: 32px;
            height: 32px;
            display: flex;
            justify-content: center;
            align-items: center
        }

        .backBar .lineBox .back uni-image[data-v-40bdd376] {
            width: 25px
        }

        .backBar .lineBox .title[data-v-40bdd376] {
            text-align: center;
            font-weight: 600;
            font-size: 22px;
            white-space: nowrap
        }

        .backBar .lineBox .ke[data-v-40bdd376] {
            width: 32px
        }

        .backBar .lineBox .more[data-v-40bdd376] {
            width: 25px;
            height: 25px;
            color: #162645;
            font-size: 12px;
            display: flex;
            justify-content: flex-end;
            align-items: center
        }

        .backBar .lineBox .more uni-image[data-v-40bdd376] {
            width: 25px;
            height: 25px
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .uni-popup[data-v-3193bb52] {
            position: fixed;
            z-index: 99
        }

        .uni-popup.top[data-v-3193bb52],
        .uni-popup.left[data-v-3193bb52],
        .uni-popup.right[data-v-3193bb52] {
            top: var(--window-top)
        }

        .uni-popup .uni-popup__wrapper[data-v-3193bb52] {
            display: block;
            position: relative
                /* iphonex 等安全区设置，底部安全区适配 */
        }

        .uni-popup .uni-popup__wrapper.left[data-v-3193bb52],
        .uni-popup .uni-popup__wrapper.right[data-v-3193bb52] {
            padding-top: var(--window-top);
            flex: 1
        }

        .fixforpc-z-index[data-v-3193bb52] {
            z-index: 999
        }

        .fixforpc-top[data-v-3193bb52] {
            top: 0
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .my-loading-pop[data-v-1544a802] {
            width: 107px;
            height: 107px
        }

        .my-loading-pop uni-image[data-v-1544a802] {
            width: 100%;
            height: 100%
        }
    </style>

    <style type="text/css">
        .uni-app--showtabbar uni-page-wrapper {
            display: block;
            height: calc(100% - 50px);
            height: calc(100% - 50px - constant(safe-area-inset-bottom));
            height: calc(100% - 50px - env(safe-area-inset-bottom));
        }

        .uni-app--showtabbar uni-page-wrapper::after {
            content: "";
            display: block;
            width: 100%;
            height: 50px;
            height: calc(50px + constant(safe-area-inset-bottom));
            height: calc(50px + env(safe-area-inset-bottom));
        }

        .uni-app--showtabbar uni-page-head[uni-page-head-type="default"]~uni-page-wrapper {
            height: calc(100% - 44px - 50px);
            height: calc(100% - 44px - constant(safe-area-inset-top) - 50px - constant(safe-area-inset-bottom));
            height: calc(100% - 44px - env(safe-area-inset-top) - 50px - env(safe-area-inset-bottom));
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .boxA[data-v-66cfd94b] {
            position: relative;
            width: 355px;
            height: 387px;
            margin: auto;
            border-radius: 13px;
            background: url(/public/static/bgi/ano.png) #242644 no-repeat top;
            background-size: 100% auto
        }

        .boxA .Announcement[data-v-66cfd94b] {
            width: 355px;
            height: 387px;
            margin: auto;
            background: rgba(36, 38, 68, .8117647058823529);
            overflow: hidden;
            margin-top: 50%;
            border-radius: 13px;
            position: relative;
            color: #fff
        }

        .boxA .Announcement .flix[data-v-66cfd94b] {
            height: 30px;
            display: flex;
            justify-content: center;
            align-items: center
        }

        .boxA .Announcement .flix>uni-view[data-v-66cfd94b]:nth-of-type(1) {
            width: 32px;
            height: 2px;
            background: linear-gradient(90deg, hsla(0, 0%, 100%, 0), #fff)
        }

        .boxA .Announcement .flix .fixB[data-v-66cfd94b] {
            font-size: 25px;
            margin: 0 2px
        }

        .boxA .Announcement .flix>uni-view[data-v-66cfd94b]:nth-of-type(3) {
            width: 32px;
            height: 2px;
            background: linear-gradient(90deg, #fff, hsla(0, 0%, 100%, 0))
        }

        .boxA .Announcement .boxCenter[data-v-66cfd94b] {
            z-index: 3;
            left: 16px;
            width: 329px;
            height: 280px;
            margin: auto
        }

        .boxA .Announcement .boxCenter .content[data-v-66cfd94b] {
            overflow-y: scroll;
            height: 100%
        }

        .boxA .Announcement .boxCenter .content .boxI[data-v-66cfd94b] {
            margin: auto;
            font-size: 12px;
            line-height: 15px
        }

        .boxA .Announcement .boxCenter .content .tu[data-v-66cfd94b] {
            width: 100%
        }

        .boxA .Announcement .boxCenter .content .tu uni-image[data-v-66cfd94b] {
            width: 100%
        }

        .boxA .Announcement .boxCenter .content uni-view[data-v-66cfd94b] {
            line-height: 15px
        }

        .boxA .Announcement .btn[data-v-66cfd94b] {
            width: 274px;
            height: 48px;
            background: #257cff;
            border-radius: 32px 32px 32px 32px;
            border: 1px solid #fff;
            margin: auto;
            font-weight: 600;
            font-size: 19px;
            text-align: center;
            line-height: 48px;
            color: #fff
        }

        .boxA .Announcement .boxT[data-v-66cfd94b] {
            width: 100%;
            height: 48px;
            background: rgba(36, 124, 255, .20784313725490197);
            position: absolute;
            bottom: 0
        }

        .boxA .Announcement .boxT .linkUrl[data-v-66cfd94b] {
            color: #fff;
            text-align: center;
            margin: auto;
            width: 242px;
            height: 48px;
            line-height: 48px
        }

        .boxA .Announcement .boxT .linkUrl uni-image[data-v-66cfd94b]:nth-of-type(1) {
            width: 29px;
            height: 29px;
            margin-right: 9px;
            vertical-align: middle
        }

        .boxA .Announcement .boxT .linkUrl uni-image[data-v-66cfd94b]:nth-of-type(2) {
            position: absolute;
            right: 16px;
            top: 13px;
            width: 19px;
            height: 19px;
            vertical-align: middle
        }

        .boxA .closeR[data-v-66cfd94b] {
            position: absolute;
            top: 12px;
            right: 12px;
            width: 25px;
            height: 25px;
            margin: auto;
            z-index: 15
        }

        .boxA .closeR uni-image[data-v-66cfd94b] {
            width: 100%
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .barBox[data-v-2ede7eee] {
            width: 100%;
            height: 64px;
            background: #3e3e3e;
            border-radius: 12px;
            position: fixed;
            bottom: 12px;
            left: 8px;
            color: #000;
            font-size: 12px;
            z-index: 3
        }

        .barBox .widthA[data-v-2ede7eee] {
            height: 64px
        }

        .barBox .BoxIner[data-v-2ede7eee] {
            position: relative;
            z-index: 90;
            width: 98%;
            margin: auto;
            display: flex;
            justify-content: space-between;
        }

        .barBox .light[data-v-2ede7eee] {
            color: #257cff;
            font-weight: 600
        }

        .barBox .dark[data-v-2ede7eee] {
            color: hsla(0, 0%, 100%, .8);
            font-weight: 400;
            font-family: Regular
        }

        .barBox .boxItem[data-v-2ede7eee] {
            width: 67px;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            height: 64px;
            text-align: center
        }

        .barBox .boxItem .b1[data-v-2ede7eee] {
            width: 67px
        }

        .barBox .boxItem .b1 uni-image[data-v-2ede7eee] {
            width: 32px;
            height: 32px
        }

        .barBox .boxItem .b1 .center[data-v-2ede7eee] {
            width: 45px;
            height: 45px
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .pages[data-v-0b75e836] {
            overflow-y: scroll
        }

        .switchBox[data-v-0b75e836] {
            position: relative;
            z-index: 2;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 371px;
            height: 48px;
            line-height: 48px;
            border-radius: 19px;
            margin: 29px auto 8px auto
        }

        .switchBox>uni-view[data-v-0b75e836] {
            width: 161px;
            text-align: center;
            font-size: 16px;
            color: #9d9d9d;
            position: relative
        }

        .switchBox .op6[data-v-0b75e836] {
            font-weight: 400;
            color: #666
        }

        .switchBox .light[data-v-0b75e836] {
            width: 161px;
            font-weight: 600;
            background: linear-gradient(270deg, rgba(37, 124, 255, 0), #257cff 50%, rgba(37, 124, 255, 0));
            border-radius: 0px 0px 0px 0px;
            color: #fff;
            -webkit-animation: rotate-data-v-0b75e836 1s linear;
            animation: rotate-data-v-0b75e836 1s linear
        }

        @-webkit-keyframes rotate-data-v-0b75e836 {
            from {
                opacity: 0
            }

            to {
                opacity: 1
            }
        }

        @keyframes rotate-data-v-0b75e836 {
            from {
                opacity: 0
            }

            to {
                opacity: 1
            }
        }

        .box-img[data-v-0b75e836] {
            width: 371px;
            height: 129px;
            background: url(/public/static/coverImg/banner.png) no-repeat top;
            background-size: 100% auto;
            margin: 16px auto 12px;
            border-radius: 10px
        }

        .boxInvite[data-v-0b75e836] {
            width: 371px;
            height: 145px;
            background: #242644;
            border-radius: 12px 12px 12px 12px;
            margin: 0 auto;
            margin-bottom: 12px
        }

        .boxInvite .box-txt[data-v-0b75e836] {
            color: #fff;
            font-size: 16px;
            font-weight: 600;
            display: flex;
            padding-left: 12px;
            align-items: center;
            padding-top: 12px
        }

        .boxInvite .box-txt uni-text[data-v-0b75e836] {
            color: #ffe558
        }

        .boxInvite .box-txt uni-image[data-v-0b75e836] {
            width: 16px;
            margin-left: 6px;
            margin-right: 3px;
            height: 16px
        }

        .boxInvite .box-txts[data-v-0b75e836] {
            padding-left: 12px;
            font-weight: 400;
            font-size: 12px;
            color: #9d9d9d;
            margin-top: 6px;
            display: flex;
            align-items: center
        }

        .boxInvite .box-txts uni-text[data-v-0b75e836] {
            color: #ffe558;
            padding-left: 2px
        }

        .boxInvite .box-long[data-v-0b75e836] {
            width: 350px;
            margin: 12px auto;
            overflow-x: auto
        }

        .boxInvite .box-long .btnNum[data-v-0b75e836] {
            width: 193px;
            height: 38px;
            background: #bd03f7;
            border-radius: 32px;
            font-weight: 600;
            font-size: 16px;
            color: #fff;
            margin: 12px auto 0;
            text-align: center;
            line-height: 38px
        }

        .boxInvite .box-long .not[data-v-0b75e836] {
            opacity: .5
        }

        .boxInvite .box-long .aaa[data-v-0b75e836] {
            display: flex;
            width: 38px;
            flex-wrap: nowrap;
            justify-content: space-between
        }

        .boxInvite .box-long .aaa .box[data-v-0b75e836] {
            position: relative;
            width: 38px;
            display: flex;
            margin-right: 9px;
            flex-direction: column;
            justify-content: space-between;
            position: relative
        }

        .boxInvite .box-long .aaa .box .box-num[data-v-0b75e836] {
            width: 38px;
            height: 48px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            background: var(--fullColor2);
            color: var(--fullColor3);
            border-radius: 3px;
            font-size: 12px;
            margin-bottom: 3px
        }

        .boxInvite .box-long .aaa .box .box-num uni-view[data-v-0b75e836] {
            zoom: .8
        }

        .boxInvite .box-long .aaa .box .box-num uni-image[data-v-0b75e836] {
            width: 19px;
            height: 19px;
            margin-top: 3px
        }

        .boxInvite .box-long .aaa .box .boxCan[data-v-0b75e836] {
            width: 38px;
            height: 19px;
            line-height: 19px;
            font-weight: 400;
            font-size: 12px;
            text-align: center;
            color: #fff
        }

        .boxInvite .box-long .aaa .box .boxNull[data-v-0b75e836] {
            width: 38px;
            height: 19px;
            font-weight: 400;
            font-size: 12px;
            text-align: center;
            color: #fff
        }

        .bigBox[data-v-0b75e836] {
            width: 371px;
            height: 484px;
            background: #242644;
            border-radius: 12px 12px 12px 12px;
            margin: auto;
            padding-top: 16px
        }

        .bigBox .qrcodeBox[data-v-0b75e836] {
            width: 180px;
            height: 180px;
            background-color: #fff;
            margin: 28px auto;
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 20px
        }

        .code-top[data-v-0b75e836] {
            width: 345px;
            margin: auto;
            display: flex;
            justify-content: flex-start
        }

        .code-top uni-image[data-v-0b75e836] {
            width: 64px;
            height: 64px;
            margin-right: 9px
        }

        .code-top .rigTeam>uni-view[data-v-0b75e836]:nth-of-type(1) {
            font-weight: 600;
            font-size: 19px;
            color: #fff
        }

        .code-top .rigTeam>uni-view[data-v-0b75e836]:nth-of-type(2) {
            margin-top: 6px;
            font-weight: 400;
            font-size: 12px;
            width: 183px;
            color: #9d9d9d
        }

        .title[data-v-0b75e836] {
            line-height: 47px;
            text-align: center;
            color: #fff;
            font-size: 19px;
            padding-top: 47px
        }

        .title2[data-v-0b75e836] {
            color: #fff;
            font-size: 16px;
            font-weight: 700;
            margin-top: 19px;
            margin-bottom: 12px
        }

        .boxs[data-v-0b75e836] {
            width: 371px;
            height: 80px;
            background: linear-gradient(180deg, #257cff, rgba(43, 104, 195, .6));
            border-radius: 12px;
            margin: 0 auto 12px;
            color: #fff
        }

        .boxs .Union[data-v-0b75e836] {
            width: 371px;
            margin: auto;
            height: 80px
        }

        .boxs .Union .innerBox[data-v-0b75e836] {
            width: 100%;
            margin: auto;
            height: 80px;
            display: flex;
            justify-content: center;
            align-items: center
        }

        .boxs .Union .innerBox .box[data-v-0b75e836] {
            text-align: center;
            width: 45%;
            height: 80px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            font-size: 12px;
            white-space: nowrap
        }

        .boxs .Union .innerBox .box>uni-view[data-v-0b75e836]:nth-of-type(1) {
            font-weight: 400;
            font-size: 16px;
            color: #fff
        }

        .boxs .Union .innerBox .box>uni-view[data-v-0b75e836]:nth-of-type(2) {
            font-weight: 600;
            font-size: 25px;
            color: #ffe558;
            margin-top: 6px
        }

        .boxs .Union .innerBox .line[data-v-0b75e836] {
            width: 1px;
            height: 32px;
            background: hsla(0, 0%, 100%, .4);
            border-radius: 0px 0px 0px 0px
        }

        .boxCommission[data-v-0b75e836] {
            width: 371px;
            height: 64px;
            background: linear-gradient(180deg, #257cff, rgba(43, 104, 195, .6));
            border-radius: 12px 12px 12px 12px;
            margin: 0 auto 12px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: #fff
        }

        .boxCommission>uni-view[data-v-0b75e836]:nth-of-type(1) {
            display: flex;
            align-items: center
        }

        .boxCommission>uni-view:nth-of-type(1) uni-image[data-v-0b75e836] {
            width: 48px;
            height: 48px;
            margin: 0 12px
        }

        .boxCommission>uni-view:nth-of-type(1)>uni-view[data-v-0b75e836] {
            font-weight: 600;
            font-size: 19px;
            color: #fff
        }

        .boxCommission>uni-view:nth-of-type(1)>uni-view>uni-view[data-v-0b75e836] {
            font-weight: 400;
            font-size: 12px;
            color: #fff;
            margin-top: 6px
        }

        .boxCommission .tBtn[data-v-0b75e836] {
            width: 96px;
            margin-right: 16px;
            height: 32px;
            border: 1px solid #fff;
            background: #257cff;
            border-radius: 32px;
            font-weight: 600;
            font-size: 16px;
            color: #fff;
            text-align: center;
            line-height: 32px
        }

        .boxCommission .tBtn2[data-v-0b75e836] {
            opacity: .5
        }

        .swiper_item[data-v-0b75e836] {
            width: 371px;
            background: #242644;
            border-radius: 12px;
            margin: auto;
            padding-top: 3px;
            padding-bottom: 8px
        }

        .swiper_item .switch_Box[data-v-0b75e836] {
            position: relative;
            width: 365px;
            height: 38px;
            margin: auto;
            background: #3d4070;
            border-radius: 9px
        }

        .swiper_item .switch_Box .lineSlide[data-v-0b75e836] {
            width: 365px;
            height: 38px;
            position: absolute;
            top: 0;
            z-index: 1
        }

        .swiper_item .switch_Box .lineSlide .sild[data-v-0b75e836] {
            width: 30%;
            transition-duration: .5s;
            height: 38px;
            background: #257cff;
            border-radius: 9px 9px 9px 9px
        }

        .swiper_item .switch_Box .tabBtns[data-v-0b75e836] {
            width: 365px;
            height: 38px;
            line-height: 38px;
            display: flex;
            justify-content: space-between;
            text-align: center;
            position: relative;
            z-index: 2
        }

        .swiper_item .switch_Box .tabBtns .checked[data-v-0b75e836] {
            width: 30%;
            text-align: center;
            font-weight: 600;
            font-size: 16px;
            color: #fff
        }

        .swiper_item .switch_Box .tabBtns .unchecked[data-v-0b75e836] {
            width: 30%;
            font-weight: 600;
            font-size: 16px;
            color: #9d9d9d
        }

        .swiper_item .box-team[data-v-0b75e836] {
            display: flex;
            flex-direction: column;
            justify-content: space-around;
            overflow-x: scroll;
            height: 123px
        }

        .swiper_item .Teamlevel[data-v-0b75e836] {
            width: 358px;
            margin: 3px auto;
            border-radius: 9px 9px 9px 9px
        }

        .swiper_item .Teamlevel .rightBox[data-v-0b75e836] {
            width: 358px;
            border-radius: 9px 9px 9px 9px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            overflow: hidden;
            color: #9d9d9d
        }

        .swiper_item .Teamlevel .rightBox .level[data-v-0b75e836] {
            height: 48px;
            width: 90%;
            margin: auto;
            text-align: center;
            white-space: nowrap;
            font-size: 16px;
            display: flex;
            justify-content: space-between;
            align-items: center
        }

        .swiper_item .Teamlevel .rightBox .level>uni-view[data-v-0b75e836] {
            text-align: left;
            font-weight: 600;
            color: #9d9d9d
        }

        .swiper_item .Teamlevel .rightBox .level>uni-view>uni-view[data-v-0b75e836] {
            font-weight: 600;
            font-size: 19px;
            color: #ffe558
        }

        .swiper_item .Teamlevel .rightBox .level uni-image[data-v-0b75e836] {
            width: 80px;
            height: 38px
        }

        .swiper_item .Teamlevel .rightBox .boxNum[data-v-0b75e836] {
            width: 100%;
            margin: auto;
            height: 32px;
            line-height: 32px;
            white-space: nowrap;
            display: flex;
            justify-content: space-between
        }

        .swiper_item .Teamlevel .rightBox .boxNum uni-view[data-v-0b75e836] {
            width: 96px;
            text-align: center;
            font-weight: 600;
            font-size: 19px;
            color: #257cff
        }

        .swiper_item .Teamlevel .rightBox .box-line[data-v-0b75e836] {
            width: 100%;
            margin: auto;
            white-space: nowrap;
            font-weight: 600;
            font-size: 16px;
            color: #9d9d9d;
            display: flex;
            justify-content: space-between
        }

        .swiper_item .Teamlevel .rightBox .box-line uni-view[data-v-0b75e836] {
            width: 96px;
            white-space: nowrap;
            text-align: center
        }

        .comom[data-v-0b75e836],
        .comom2[data-v-0b75e836] {
            width: 371px;
            margin: 0 auto 6px;
            display: flex;
            justify-content: space-around;
            align-items: center;
            position: relative;
            z-index: 2;
            padding: 5px 0
        }

        .comom>uni-view[data-v-0b75e836]:nth-of-type(1),
        .comom2>uni-view[data-v-0b75e836]:nth-of-type(1) {
            width: 215px;
            font-weight: 400;
            font-size: 16px;
            display: flex
        }

        .comom>uni-view:nth-of-type(1)>uni-view[data-v-0b75e836]:nth-of-type(1),
        .comom2>uni-view:nth-of-type(1)>uni-view[data-v-0b75e836]:nth-of-type(1) {
            font-weight: 400;
            font-size: 16px;
            color: #9d9d9d
        }

        .comom>uni-view:nth-of-type(1)>uni-view[data-v-0b75e836]:nth-of-type(2),
        .comom2>uni-view:nth-of-type(1)>uni-view[data-v-0b75e836]:nth-of-type(2) {
            color: #fff
        }

        .comom .tBtn[data-v-0b75e836],
        .comom2 .tBtn[data-v-0b75e836] {
            width: 64px;
            height: 38px;
            background: #257cff;
            border-radius: 9px 9px 9px 9px;
            font-weight: 600;
            font-size: 19px;
            color: #fff;
            text-align: center;
            line-height: 38px
        }

        .comom>uni-view[data-v-0b75e836]:nth-of-type(1) {
            align-items: center
        }

        .comom>uni-view:nth-of-type(1)>uni-view[data-v-0b75e836]:nth-of-type(1) {
            margin-right: 32px
        }

        .comom2>uni-view[data-v-0b75e836]:nth-of-type(1) {
            flex-direction: column
        }

        .comom2>uni-view:nth-of-type(1)>uni-view[data-v-0b75e836]:nth-of-type(2) {
            margin-right: 32px;
            width: 163px;
            word-break: break-word;
            line-height: 18px;
            text-decoration: underline
        }

        .box-bn[data-v-0b75e836] {
            width: 371px;
            height: 64px;
            margin: 0 auto 12px;
            background: url(https://digitdesh.hr6.xyz/public//public/static/bgi/tb.png) no-repeat top;
            background-size: 100% auto;
            position: relative
        }

        .box-bn uni-image[data-v-0b75e836] {
            width: 71px;
            height: 74px;
            position: absolute;
            top: -9px;
            left: 12px
        }

        .box-climbing[data-v-0b75e836] {
            width: 371px;
            margin: 12px auto 0;
            background: #242644;
            border-radius: 12px 12px 12px 12px;
            padding-bottom: 12px
        }

        .box-climbing .c1[data-v-0b75e836] {
            font-weight: 600;
            font-size: 16px;
            color: #fff;
            padding-left: 12px;
            padding-top: 12px;
            margin-bottom: 12px
        }

        .box-climbing .box-flex[data-v-0b75e836] {
            display: flex;
            justify-content: space-around
        }

        .box-climbing .box-flex .box-left[data-v-0b75e836] {
            position: relative;
            top: 26px;
            width: 9px
        }

        .box-climbing .box-flex .box-left>uni-view[data-v-0b75e836] {
            width: 9px;
            display: flex;
            justify-content: space-around;
            flex-direction: column;
            align-items: center
        }

        .box-climbing .box-flex .box-left>uni-view .box-cricle[data-v-0b75e836] {
            width: 9px;
            height: 9px;
            border: 1px solid;
            border-color: var(--fullColor);
            border-radius: 50%
        }

        .box-climbing .box-flex .box-left>uni-view .box-dash[data-v-0b75e836] {
            width: 0px;
            height: 86px;
            border: 1px dashed;
            border-color: var(--fullColor);
            margin: 5px 0
        }

        .box-climbing .box-flex .box-left>uni-view .finished[data-v-0b75e836] {
            width: 9px;
            height: 9px;
            background: #257cff;
            border: 1px solid #257cff
        }

        .box-climbing .box-flex .box-left>uni-view .not[data-v-0b75e836] {
            width: 9px;
            height: 9px;
            border: 1px solid #9d9d9d
        }

        .box-climbing .box-right[data-v-0b75e836] {
            width: 323px
        }

        .box-climbing .box-right .box-one[data-v-0b75e836] {
            width: 323px;
            height: 96px;
            padding: 12px 0 6px;
            background: #3d4070;
            border-radius: 12px 12px 12px 12px;
            margin-bottom: 9px;
            display: flex;
            justify-content: space-around;
            flex-direction: column
        }

        .box-climbing .box-right .box-one>uni-view[data-v-0b75e836]:nth-of-type(1) {
            font-weight: 600;
            width: 269px;
            font-size: 12px;
            color: #fff;
            display: flex;
            justify-content: center
        }

        .box-climbing .box-right .box-one>uni-view:nth-of-type(1) uni-image[data-v-0b75e836] {
            width: 32px;
            height: 32px;
            margin: 0 6px 0 7px
        }

        .box-climbing .box-right .box-one>uni-view[data-v-0b75e836]:nth-of-type(2) {
            display: flex;
            justify-content: space-around
        }

        .box-climbing .box-right .box-one>uni-view:nth-of-type(2)>uni-view[data-v-0b75e836] {
            display: flex;
            align-items: center;
            font-weight: 400;
            font-size: 12px;
            color: #9d9d9d;
            margin-top: 4px
        }

        .box-climbing .box-right .box-one>uni-view:nth-of-type(2)>uni-view>uni-view[data-v-0b75e836] {
            margin-left: 3px;
            font-weight: 600;
            font-size: 16px;
            color: #ffe558
        }

        .box-climbing .box-right .box-one>uni-view:nth-of-type(2)>uni-view>uni-view uni-text[data-v-0b75e836] {
            color: #fff
        }

        .box-climbing .box-right .box-one .btns[data-v-0b75e836] {
            font-weight: 600;
            font-size: 12px;
            color: #fff;
            width: 193px;
            height: 32px;
            margin-top: 12px;
            background: #257cff;
            border-radius: 16px;
            text-align: center;
            margin: auto;
            line-height: 32px
        }

        .box-climbing .box-right .box-one .btns2[data-v-0b75e836] {
            font-weight: 600;
            font-size: 12px;
            color: #fff;
            width: 193px;
            height: 32px;
            margin-top: 12px;
            background: #9d9d9d;
            border-radius: 16px;
            text-align: center;
            margin: auto;
            line-height: 32px
        }

        .box-climbing .box-right .box-one .btns3[data-v-0b75e836] {
            font-weight: 600;
            font-size: 12px;
            color: #fff;
            width: 193px;
            height: 32px;
            margin-top: 12px;
            background: rgba(37, 124, 255, .3333333333333333);
            border: 1px solid hsla(0, 0%, 100%, .3333333333333333);
            border-radius: 16px;
            text-align: center;
            margin: auto;
            line-height: 32px
        }

        .RuleBox[data-v-0b75e836] {
            width: 371px;
            margin: 12px auto;
            background: #242644;
            border-radius: 12px
        }

        .RuleBox .titleTeam[data-v-0b75e836] {
            font-weight: 400;
            font-size: 16px;
            color: #fff;
            text-align: left;
            padding: 16px 0 9px 0
        }

        .RuleBox .boxIn[data-v-0b75e836] {
            width: 345px;
            margin: auto;
            font-weight: 400;
            font-size: 16px;
            color: #9d9d9d
        }
    </style>

    <style type="text/css">
        .uni-app--showtabbar uni-page-wrapper {
            display: block;
            height: calc(100% - 50px);
            height: calc(100% - 50px - constant(safe-area-inset-bottom));
            height: calc(100% - 50px - env(safe-area-inset-bottom));
        }

        .uni-app--showtabbar uni-page-wrapper::after {
            content: "";
            display: block;
            width: 100%;
            height: 50px;
            height: calc(50px + constant(safe-area-inset-bottom));
            height: calc(50px + env(safe-area-inset-bottom));
        }

        .uni-app--showtabbar uni-page-head[uni-page-head-type="default"]~uni-page-wrapper {
            height: calc(100% - 44px - 50px);
            height: calc(100% - 44px - constant(safe-area-inset-top) - 50px - constant(safe-area-inset-bottom));
            height: calc(100% - 44px - env(safe-area-inset-top) - 50px - env(safe-area-inset-bottom));
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .account[data-v-d20221d0] {
            width: 100%;
            height: 100%
        }

        .boxBox[data-v-d20221d0] {
            width: 371px;
            background: #242644;
            border-radius: 19px;
            padding-bottom: 20px;
            color: #fff;
            margin: 193px auto 0;
            position: relative
        }

        .boxBox .topFixed[data-v-d20221d0] {
            width: 25px;
            height: 25px;
            background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAADnUlEQVRIS7VVTWhcVRg933uZDrykwmxCHo0U7EKoG6ugYtt0oxZ3usmiTmM1k947Q13YhVb69+pvhYIQ4sy9k8afcaxL3UnVjT8VK2gFseAigtTyXIQsbBK0mXlf+Yb3wsvkTToi3tXj3e+ew/3O+c4l/M+L+sAna+0uZt5FRCPMLGdCIroShuFPQRBEm2H0JGg0GoMrKyvPAzhMRHf2APmDmWc8z5uZmJhYzqrJJKhWq/scx2kIMDNfBPBhFEXfuq57rVAo0MLCwujAwMBuZi4CeIyZrwM4oLX+qptkA4G19gCA95h53nXdZ6ampr7brAW1Wm234zjnAewAcEgpdSFdv47AGDNGRF8w89e5XO6JycnJG31ohGazecfS0tLHRLS33W4/WqlUvkzOrRHEPf+ViG4MDg4+WCwW/+oHPKmZm5vb2mq1vmdmz/O8nYkmawTGmBeJ6GwURXvK5fIlOVir1bYR0ZjW+qMsslqtNp7L5S6XSqXfZX92dvYh0YqZT2mtX5V/HYIgCBzf96XoqlJqfwJWr9cPMfO7AM4qpV5Kk1hrT8tRAM8ppWaSPWPMpwDu0VpvB9DxNKy19wH4IYqiiXK5/EEKSGbgbQBlAK8rpY7H9Qn4O2EYTqVnwRhTJCLBuF8p9WOHwBgzSUTn2+32jkql8ltXO9IkATM7RHQKwAZwOVetVu9yXXeemUta67mE4AQRvVIoFPLj4+M3M/qdJpHtehiG5awpDoJgi+/7/wA4oZR6LWmRXF1E2aKUWs0S1Fr7BoBj8d4ZpZT0f8Oanp7O5/P5v5n5pAjdV4uMMeeI6KgYC0AewLMisFLqTDdDZosSkZn5oNa6mSUyM5/TWr8QBAH5vj/bi6Rerx9k5sY6kcWuxhix6S9a68cTAmvtYTFZt01jW3dImPlprbUAdpa1VrJrZxiG20Wj9KCJ0C87jvNwkj/xdfcqpd7vboWQjIyMHCWii0qpn+PBlFz6hpmPaa3fXBs0+Yij4iqAlVwu90C/OZQQSx4tLy9fZuatnufdvSEqYg/vc133cwm7oaGhJ/vNI8mh1dXVTyTsmPmRdGz3jGsA81EUlZJcyrKk/IvzR+Lk9nGdypMxABeIaBuAz4io2Wq1LrVareuLi4s8PDw8KloBeIqI9jPzNYmZdEwnWLd7Mo8Q0REAo1k3EGCZas/z3vpXT2YaLLbkvfLoA/CJiJn5T3n0lVJXJDF7tW+dizYr+i97twBk8c0ogIpR1QAAAABJRU5ErkJggg==) no-repeat top;
            background: 100% auto;
            position: absolute;
            right: 12px;
            top: 12px
        }

        .boxBox .b1[data-v-d20221d0] {
            font-weight: 600;
            font-size: 25px;
            color: #fff;
            text-align: center;
            padding-top: 25px;
            padding-bottom: 7px
        }

        .boxBox .b2[data-v-d20221d0] {
            font-weight: 400;
            font-size: 16px;
            color: #fff;
            text-align: center
        }

        .boxBox .b2 uni-image[data-v-d20221d0] {
            width: 16px;
            height: 16px;
            margin-right: 6px
        }

        .boxBox .tit[data-v-d20221d0] {
            text-align: center;
            font-size: 19px;
            font-weight: 700
        }

        .txtGray[data-v-d20221d0] {
            width: 371px;
            margin: auto;
            font-size: 12px;
            font-family: Poppins;
            font-weight: 400;
            color: #445a64;
            line-height: 18px
        }

        .lineBox[data-v-d20221d0] {
            width: 371px;
            height: 1px;
            background: #e9e9e9;
            margin: 19px auto
        }

        .title[data-v-d20221d0] {
            font-weight: 400;
            font-size: 16px;
            padding-left: 12px;
            color: #fff;
            text-align: left;
            white-space: nowrap;
            margin: 0 auto 6px;
            padding-top: 19px
        }

        .box[data-v-d20221d0] {
            position: relative;
            z-index: 2
        }

        .box .inputBox[data-v-d20221d0] {
            width: 345px;
            height: 48px;
            border: 1px solid #334a85;
            border-radius: 9px;
            margin: auto;
            display: flex;
            align-items: center;
            justify-content: center
        }

        .box .inputBox .Ptxt[data-v-d20221d0] {
            font-weight: 400;
            color: #9d9d9d;
            text-indent: 16px;
            font-size: 16px
        }

        .box .inputBox uni-input[data-v-d20221d0] {
            width: 100%;
            font-weight: 600;
            height: 48px;
            text-indent: 16px;
            line-height: 48px
        }

        .box .rightBox[data-v-d20221d0] {
            width: 100%;
            text-align: left;
            text-indent: 16px
        }

        .box .rightBox uni-image[data-v-d20221d0] {
            width: 12px;
            height: 12px;
            margin-left: 8px;
            margin-right: 16px
        }

        .box .boxItem[data-v-d20221d0] {
            position: absolute;
            left: 13px;
            top: 96px;
            background: #fff;
            box-shadow: 0 0 5px #cacaca;
            line-height: 43px;
            padding: 16px;
            color: #162645;
            border-radius: 6px 6px 6px 6px
        }

        .box .boxItem .light[data-v-d20221d0] {
            border: 2px solid #257cff;
            background-color: #257cff
        }

        .box .boxItem uni-text[data-v-d20221d0] {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            display: inline-block;
            border: 2px solid #162645;
            margin-right: 10px
        }

        .buttons[data-v-d20221d0] {
            margin: 25px auto 0
        }

        .unbuttons[data-v-d20221d0] {
            opacity: .6;
            pointer-events: none
        }
    </style>
    <style type="text/css">
        @charset "UTF-8";

        /**
     * 这里是uni-app内置的常用样式变量
     *
     * uni-app 官方扩展插件及插件市场（https://ext.dcloud.net.cn）上很多三方插件均使用了这些样式变量
     * 如果你是插件开发者，建议你使用scss预处理，并在插件代码中直接使用这些变量（无需 import 这个文件），方便用户通过搭积木的方式开发整体风格一致的App
     *
     */
        /**
     * 如果你是App开发者（插件使用者），你可以通过修改这些变量来定制自己的插件主题，实现自定义主题功能
     *
     * 如果你的项目同样使用了scss预处理，你也可以直接在你的 scss 代码中使用如下变量，同时无需 import 这个文件
     */
        /* 颜色变量 */
        /* 行为相关颜色 */
        /* 文字基本颜色 */
        /* 背景颜色 */
        /* 边框颜色 */
        /* 尺寸变量 */
        /* 文字尺寸 */
        /* 图片尺寸 */
        /* Border Radius */
        /* 水平间距 */
        /* 垂直间距 */
        /* 透明度 */
        /* 文章场景相关 */
        .pages[data-v-1735120c] {
            overflow-y: scroll
        }

        .pages .topBanner[data-v-1735120c] {
            width: 100%;
            position: relative
        }

        .pages .topBanner .signUp[data-v-1735120c] {
            width: 371px;
            margin: auto
        }

        .pages .topBanner .signUp .imageBox[data-v-1735120c] {
            width: 80px;
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: hidden;
            margin: auto
        }

        .pages .topBanner .signUp .imageBox uni-image[data-v-1735120c] {
            width: 80px;
            height: 80px;
            border-radius: 50%
        }

        .pages .topBanner .signUp .box[data-v-1735120c] {
            text-align: center;
            margin: 12px auto 0;
            height: 53px;
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            white-space: nowrap
        }

        .pages .topBanner .signUp .box>uni-view[data-v-1735120c]:nth-of-type(1) {
            font-weight: 600;
            font-size: 19px;
            color: #fff
        }

        .pages .topBanner .signUp .box>uni-view[data-v-1735120c]:nth-of-type(2) {
            font-weight: 400;
            font-size: 16px;
            color: #9d9d9d;
            margin-top: 6px
        }

        .pages .box-bn[data-v-1735120c] {
            width: 371px;
            height: 64px;
            margin: 0 auto 12px;
            background: url(https://digitdesh.hr6.xyz/public//public/static/bgi/tb.png) no-repeat top;
            background-size: 100% auto;
            position: relative
        }

        .pages .box-bn uni-image[data-v-1735120c] {
            width: 71px;
            height: 74px;
            position: absolute;
            top: -9px;
            left: 12px
        }

        .pages .innerBox[data-v-1735120c] {
            width: 371px;
            height: 113px;
            background: linear-gradient(180deg, #257cff, rgba(43, 104, 195, .6));
            border-radius: 12px 12px 12px 12px;
            margin: 19px auto 16px;
            display: flex;
            align-items: center
        }

        .pages .innerBox .line-up[data-v-1735120c] {
            width: 1px;
            height: 32px;
            background: hsla(0, 0%, 100%, .3);
            border-radius: 0px 0px 0px 0px
        }

        .pages .innerBox .info[data-v-1735120c] {
            width: 185px;
            line-height: 21px;
            display: flex;
            height: 43px;
            justify-content: center;
            flex-direction: column;
            text-align: center;
            color: #fff
        }

        .pages .innerBox .info .account[data-v-1735120c] {
            font-weight: 400;
            font-size: 12px;
            color: #fff
        }

        .pages .innerBox .info .userName[data-v-1735120c] {
            font-weight: 600;
            font-size: 19px;
            color: #ffe558;
            margin-top: 3px
        }

        .pages .innerBox .info .goBtn[data-v-1735120c],
        .pages .innerBox .info .goBtn2[data-v-1735120c] {
            width: 113px;
            height: 32px;
            border-radius: 32px;
            text-align: center;
            line-height: 32px;
            font-weight: 500;
            font-size: 19px;
            margin: 9px auto 0;
            color: #fff
        }

        .pages .innerBox .info .goBtn[data-v-1735120c] {
            background: #fd5b02;
            border: 1px solid #fff
        }

        .pages .innerBox .info .goBtn2[data-v-1735120c] {
            background: #11cb46;
            border: 1px solid #fff
        }

        .pages .btn-box[data-v-1735120c] {
            width: 371px;
            margin: auto;
            border-radius: 12px;
            background: #fff
        }

        .pages .btn-box .listIcon[data-v-1735120c] {
            width: 339px;
            margin: auto;
            color: #000
        }

        .pages .btn-box .listIcon .IconBox[data-v-1735120c] {
            text-align: center;
            width: 64px;
            height: 107px;
            border-radius: 32px
        }

        .pages .btn-box .listIcon .IconBox .txt[data-v-1735120c] {
            font-weight: 400;
            font-size: 16px;
            color: #000
        }

        .pages .btn-box .listIcon .IconBox .image[data-v-1735120c] {
            width: 67px;
            height: 48px;
            margin: 12px auto 6px;
            display: flex;
            justify-content: center;
            align-items: center
        }

        .pages .btn-box .listIcon .IconBox .image uni-image[data-v-1735120c] {
            width: 67px;
            height: 48px
        }

        .pages .titleTxt[data-v-1735120c] {
            width: 371px;
            margin: auto;
            font-weight: 600;
            font-size: 19px;
            color: #fff;
            display: flex;
            align-items: center
        }

        .pages .titleTxt uni-image[data-v-1735120c] {
            width: 32px;
            height: 32px;
            margin-right: 6px
        }

        .pages .boxBorder[data-v-1735120c] {
            width: 371px;
            height: 371px;
            margin: 9px auto 0;
            background: #242644;
            border-radius: 12px;
            position: relative;
            display: flex;
            align-items: center;
            flex-wrap: wrap
        }

        .pages .boxBorder .itemBox[data-v-1735120c] {
            width: 30%;
            margin: 0 auto;
            height: 96px
        }

        .pages .boxBorder .itemBox .left[data-v-1735120c] {
            width: 90%;
            text-align: center
        }

        .pages .boxBorder .itemBox .left>uni-view[data-v-1735120c]:nth-of-type(1) {
            border-radius: 50%;
            background: #257cff;
            width: 48px;
            height: 48px;
            margin: auto;
            display: flex;
            justify-content: center;
            align-items: center
        }

        .pages .boxBorder .itemBox .left>uni-view:nth-of-type(1) uni-image[data-v-1735120c] {
            width: 25px;
            height: 25px
        }

        .pages .boxBorder .itemBox .left>uni-view[data-v-1735120c]:nth-of-type(2) {
            font-weight: 400;
            font-size: 16px;
            color: #fff;
            margin-top: 6px
        }

        .pages .btnOut[data-v-1735120c] {
            width: 323px;
            height: 48px;
            border-radius: 16px;
            border: 1px solid #2d3132;
            margin: auto;
            color: #2d3132;
            text-align: center;
            line-height: 48px;
            margin-top: 19px
        }

        .pages .mask[data-v-1735120c] {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 900;
            background-color: rgba(0, 0, 0, .788235294117647)
        }

        .pages .Card[data-v-1735120c] {
            position: fixed;
            top: 50%;
            left: 50%;
            -webkit-transform: translate(-50%, -50%);
            transform: translate(-50%, -50%);
            z-index: 999;
            width: 323px;
            background: #fff;
            border-radius: 10px;
            color: #162645;
            overflow: hidden
        }

        .pages .Card uni-view[data-v-1735120c] {
            width: 323px;
            margin: auto;
            text-align: center
        }

        .pages .Card .d1[data-v-1735120c] {
            font-size: 19px;
            margin: 12px auto;
            text-align: center
        }

        .pages .Card .d2[data-v-1735120c] {
            font-size: 15px;
            font-weight: 600;
            padding-bottom: 25px
        }

        .pages .Card .yes[data-v-1735120c] {
            line-height: 43px;
            font-size: 16px;
            color: #fff;
            width: 274px;
            height: 43px;
            background: #257cff;
            border-radius: 32px 32px 32px 32px;
            text-align: center
        }

        .pages .Card .no[data-v-1735120c] {
            width: 50%;
            height: 48px;
            line-height: 48px;
            color: #257cff;
            font-size: 16px;
            text-align: center
        }
    </style>
@endsection

@section('body')

<body class="uni-body pages-mine-mine" style="overflow: visible;">
    <uni-app class="uni-app--maxwidth">
        <uni-page>
            <uni-page-wrapper>
                <uni-page-body>
                    <uni-view data-v-1735120c="" class="pages">
                        <uni-view data-v-1544a802="" data-v-1735120c=""></uni-view>
                        <uni-view data-v-1735120c="" class="foxTop">
                            <uni-view data-v-1735120c="" class="topBanner">
                                <uni-view data-v-1735120c="" style="height: 53px;"></uni-view>
                                <uni-view data-v-1735120c="" class="signUp">
                                    <uni-view data-v-1735120c="" class="imageBox">
                                        <uni-image data-v-1735120c="" style="height: 80px;">
                                            <div
                                                style="background-image: url(/public/static/favicon.png); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="/public/static/favicon.png" draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="" class="box">
                                        <uni-view data-v-1735120c="">A/C-{{user()->phone}}</uni-view>
                                        <uni-view data-v-1735120c="" class="redTxt">ID:{{user()->ref_id}}</uni-view>
                                    </uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="innerBox flexAround ">
                                <uni-view data-v-1735120c="" class="info">
                                    <uni-view data-v-1735120c="" class="account">Account balance</uni-view>
                                    <uni-view data-v-1735120c="" class="userName Blod">{{price(user()->balance)}}</uni-view>
                                    <uni-view data-v-1735120c="" class="goBtn"
                                        onclick="window.location.href='/deposit'">Top-up</uni-view>
                                </uni-view>
                                <uni-view data-v-1735120c="" class="line-up"></uni-view>
                                <uni-view data-v-1735120c="" class="info">
                                    <uni-view data-v-1735120c="" class="account">Purchase amount</uni-view>
                                    <uni-view data-v-1735120c="" class="userName Blod">Rs.3300</uni-view>
                                    <uni-view data-v-1735120c="" class="goBtn2"
                                        onclick="window.location.href='/withdraw'">Withdrawals</uni-view>
                                </uni-view>
                            </uni-view>
                        </uni-view>
                        <uni-view data-v-1735120c="" class="titleTxt">
                            <uni-image data-v-1735120c="" style="height: 32px;">
                                <div
                                    style="background-image: url(data:image/png;base64,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); background-size: 100% 100%; background-repeat: no-repeat;">
                                </div>
                                <uni-resize-sensor>
                                    <div>
                                        <div></div>
                                    </div>
                                    <div>
                                        <div></div>
                                    </div>
                                </uni-resize-sensor>
                                <img src="data:image/png;base64,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"
                                    draggable="false">
                            </uni-image>
                            Other functions
                        </uni-view>
                        <uni-view data-v-1735120c="" class=" boxBorder ">
                            <uni-view data-v-1735120c="" class="itemBox"
                                onclick="window.location.href='/change/password'">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAACH0lEQVRIS9WWTYiOURTHf/8xGUqzGMoUQlGzsfA5JhtlQyk7CykLg6KwUIyVlRGyGBElGmXBhLCQnc0MC5GFUlKKYjYWbIyPOTqP2+PO9Xy87/RunN373P/5/+/5uucVDZqZ9QK3gR/ATkmjjbiqDmRmjukHhoBZAT8BHPNvkiarOKYImNlM4BcwB1gErAnkG0pIngGXgafAB+Ar0CbJo8wsFzCzc8Dh+FtddCXnHtEFSQdTgZ/AjGmSpm6TkjKuOAJrEfmf1EgZ938hcAc4C1wHluXFbVEEN4BdgfQJsLZK4BvQ0UQdrgJ7Q2PcArZFvhOSspmJa/AJmB+BTgCPgBFgYSLs5HsAnxs/35qcj0vqTgWeAysj4CFJQ2a2GHgMLAlnV4B9gfwusLkg6heSVqUCN4HtEdgnerek4UjkIXAgpLKM3ClGJGVccYoGgJPJbXwq+yVdM7O5wGdgNnAf2FRRrwFJp1KBPmCswCkW6QTuARtrmqFPkr9PUyJoBz4C80pELoU2zFuxRGQcWCDJU/xXwH+Y2RngSBOtWgQ9LeloPg8xwsyWAq9Dh0xH57tPs6T3hQItiGJQ0vH4Zv9sNDPzLvGZ6GkyhFfAakm+7XIrXJlmthzwt8VbsxHzwq6X9C4Fl+5kM1sBPAB8kqvsLbBF0psiUOXSN7Mu4Dywo8DZF9Qw4E/Kl7Ib1P6rCIVfB+wPj5qvVh+2i5Je1uXvN3O3rhmLby1yAAAAAElFTkSuQmCC); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAACH0lEQVRIS9WWTYiOURTHf/8xGUqzGMoUQlGzsfA5JhtlQyk7CykLg6KwUIyVlRGyGBElGmXBhLCQnc0MC5GFUlKKYjYWbIyPOTqP2+PO9Xy87/RunN373P/5/+/5uucVDZqZ9QK3gR/ATkmjjbiqDmRmjukHhoBZAT8BHPNvkiarOKYImNlM4BcwB1gErAnkG0pIngGXgafAB+Ar0CbJo8wsFzCzc8Dh+FtddCXnHtEFSQdTgZ/AjGmSpm6TkjKuOAJrEfmf1EgZ938hcAc4C1wHluXFbVEEN4BdgfQJsLZK4BvQ0UQdrgJ7Q2PcArZFvhOSspmJa/AJmB+BTgCPgBFgYSLs5HsAnxs/35qcj0vqTgWeAysj4CFJQ2a2GHgMLAlnV4B9gfwusLkg6heSVqUCN4HtEdgnerek4UjkIXAgpLKM3ClGJGVccYoGgJPJbXwq+yVdM7O5wGdgNnAf2FRRrwFJp1KBPmCswCkW6QTuARtrmqFPkr9PUyJoBz4C80pELoU2zFuxRGQcWCDJU/xXwH+Y2RngSBOtWgQ9LeloPg8xwsyWAq9Dh0xH57tPs6T3hQItiGJQ0vH4Zv9sNDPzLvGZ6GkyhFfAakm+7XIrXJlmthzwt8VbsxHzwq6X9C4Fl+5kM1sBPAB8kqvsLbBF0psiUOXSN7Mu4Dywo8DZF9Qw4E/Kl7Ib1P6rCIVfB+wPj5qvVh+2i5Je1uXvN3O3rhmLby1yAAAAAElFTkSuQmCC"
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">Update Password</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox" onclick="window.location.href='/add-bank-create'">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAABYUlEQVRIS8WVPS9EQRSGn9dHsSURtVJHRdRiYys6iUJDKRsqBY2EGoVECIlKQkO14gf4iIa/4QcgFkfO5t5kct272ex115RnZt7nnDnvzIiChwrWpwEwswqwDYwAXTmhX8ATsCHpWmZWBmp/IJzM6xsoO+AeGM+Zddb2Owd8AL0FAT4dYAWJN2T/DXAIXADDwCbQH1S5C1xmVD0IHITr0yo4lzQXC5jZdOSyOFSS9J51rGZ2CizE82mAJUnHAaAHqAeCO8BVBmAAOAL6mgH2JS0HgDHgoV0jpFVwImkxAExGR9SWlZOAF2BI0luYsZntAdUoltbkGWA1rcok4EzSfHKhmU0BN1H8V5PNrAS8tgJ4BNYAf0fC4YD1KJDW5FlgpRVAu73M3NeRm+wed68XMepewS0wUYS63x8HuM/dIXl/smSObpRK/GX6e7MFjALdOatx4Wd3naRaZz79nBk33f4Dh+GR42RwvKIAAAAASUVORK5CYII=); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAABYUlEQVRIS8WVPS9EQRSGn9dHsSURtVJHRdRiYys6iUJDKRsqBY2EGoVECIlKQkO14gf4iIa/4QcgFkfO5t5kct272ex115RnZt7nnDnvzIiChwrWpwEwswqwDYwAXTmhX8ATsCHpWmZWBmp/IJzM6xsoO+AeGM+Zddb2Owd8AL0FAT4dYAWJN2T/DXAIXADDwCbQH1S5C1xmVD0IHITr0yo4lzQXC5jZdOSyOFSS9J51rGZ2CizE82mAJUnHAaAHqAeCO8BVBmAAOAL6mgH2JS0HgDHgoV0jpFVwImkxAExGR9SWlZOAF2BI0luYsZntAdUoltbkGWA1rcok4EzSfHKhmU0BN1H8V5PNrAS8tgJ4BNYAf0fC4YD1KJDW5FlgpRVAu73M3NeRm+wed68XMepewS0wUYS63x8HuM/dIXl/smSObpRK/GX6e7MFjALdOatx4Wd3naRaZz79nBk33f4Dh+GR42RwvKIAAAAASUVORK5CYII="
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">Account</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox" onclick="window.location.href='/history'">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB0UlEQVRIS93WS6jNURTH8c/yyCOugSJEkhgzMFB0DQyULpGBCcX4lqG45Xp3lZLMjEyEDEQMZORRZIaUYkCSUgoTSW2tOqdO//7nf/43pKw6dTp7rfXd+7fXXuuEAVZKuYWtNW43I2LboPgopUzBRezGrE7AWESczO+llC8Yqkn0LSKGSik30AV9wkREnO36J2AnrlcS3MdwRC6XTdhYA3iAJ3iDhZX1DRHxMH/LDIdxoibBbTxtkCCwBetqfA5FxOku4AjGB2k5yfXxiDj6fwNSv1ctZZmD9J/b4z9QopURkdUx0Eops/EcKyYD+In8tLGpmF5xHHiCNombfP4tIFvDZnxteYzFuItpbe/gO7bjY0vAIuSrz57Wtb8i0fvOqRfgwp98yZdxCaswD8/wKCI+N7WKd/hQkShLcU1FilOdXWez7L2DhIxExNvspnXNbklEVAE5G65hVwf8Esdwpc9dvcgN9QPkfHhdCZyB/T3D5wD2YG1DMYz0A7QpoGHcq0hTjRv7HcB65Lye37Cb0QSM4nybLVd89nZGacpWZz+wOgFLO90wS2wydgf78BjLawIPRsREztWsjmXI4V/376EJeg4zcRw7et7BmYi4moG/AIEBtWJQeR3kAAAAAElFTkSuQmCC); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB0UlEQVRIS93WS6jNURTH8c/yyCOugSJEkhgzMFB0DQyULpGBCcX4lqG45Xp3lZLMjEyEDEQMZORRZIaUYkCSUgoTSW2tOqdO//7nf/43pKw6dTp7rfXd+7fXXuuEAVZKuYWtNW43I2LboPgopUzBRezGrE7AWESczO+llC8Yqkn0LSKGSik30AV9wkREnO36J2AnrlcS3MdwRC6XTdhYA3iAJ3iDhZX1DRHxMH/LDIdxoibBbTxtkCCwBetqfA5FxOku4AjGB2k5yfXxiDj6fwNSv1ctZZmD9J/b4z9QopURkdUx0Eops/EcKyYD+In8tLGpmF5xHHiCNombfP4tIFvDZnxteYzFuItpbe/gO7bjY0vAIuSrz57Wtb8i0fvOqRfgwp98yZdxCaswD8/wKCI+N7WKd/hQkShLcU1FilOdXWez7L2DhIxExNvspnXNbklEVAE5G65hVwf8Esdwpc9dvcgN9QPkfHhdCZyB/T3D5wD2YG1DMYz0A7QpoGHcq0hTjRv7HcB65Lye37Cb0QSM4nybLVd89nZGacpWZz+wOgFLO90wS2wydgf78BjLawIPRsREztWsjmXI4V/376EJeg4zcRw7et7BmYi4moG/AIEBtWJQeR3kAAAAAElFTkSuQmCC"
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">Bill</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox" onclick="window.location.href='/about-us'">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB/klEQVRIS72VzYuOYRTGf5evLFAWRPLRlBKz4U+QFTsLGcpCytZH0wxbJTK2SikLmZmUv8DEn8DCR1JiRkbsKBsfR9fred5ej+e573te5V7e93XOde5zTtclEicidgBjwH5gFNhQwT8Cz4A5YFbS2640anuIiK3AFeAIsCJVBPATuAdMSJpvYv8iiIijwE1gXSZx8/kLcEqSyfrnD4KIOA9cA1p/VkAYwLik6zW2nygi3I7ZRPLPwDngJXAWONxBaJJjkpzrd6URsQ14CqxNVOnKpir8auA9sL4D72JGJS3UBDOAe586JyXdrgER8Q7YkgiYlnRcEbEdeA0syxA8Bw4BTjwOXM7gvwM7TTBRrWTBDHuQb8DKQvBFEzwADmQCvN9fG5gRYFUmbs4EHtbmDPCEpDuDmIh4AezKxH0wgXu1vODLU5Lc+94pJPixFILHkvYNQ7AIbCr4wRNJe5dIsFg6ZOcdhqA35AsFOz0swaQJrPmvCmS5OQP7we5Eay3jI7VU3LVAJcCW4klJNwZmcAa4BKzpiLMRjdUENhiLXZcHHAQetSTy/f2WexdksZsflGuL3fQ/eEH/cxbO2nj+n+EM9NbGcyvjDW1ttwecro2mBnSZvg3oamX6ORm31NiHvQQLTeak91Ze4dlYbfcAG6sEn6qleAjMSHrTtYG/AO/wxmW7m5seAAAAAElFTkSuQmCC); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB/klEQVRIS72VzYuOYRTGf5evLFAWRPLRlBKz4U+QFTsLGcpCytZH0wxbJTK2SikLmZmUv8DEn8DCR1JiRkbsKBsfR9fred5ej+e573te5V7e93XOde5zTtclEicidgBjwH5gFNhQwT8Cz4A5YFbS2640anuIiK3AFeAIsCJVBPATuAdMSJpvYv8iiIijwE1gXSZx8/kLcEqSyfrnD4KIOA9cA1p/VkAYwLik6zW2nygi3I7ZRPLPwDngJXAWONxBaJJjkpzrd6URsQ14CqxNVOnKpir8auA9sL4D72JGJS3UBDOAe586JyXdrgER8Q7YkgiYlnRcEbEdeA0syxA8Bw4BTjwOXM7gvwM7TTBRrWTBDHuQb8DKQvBFEzwADmQCvN9fG5gRYFUmbs4EHtbmDPCEpDuDmIh4AezKxH0wgXu1vODLU5Lc+94pJPixFILHkvYNQ7AIbCr4wRNJe5dIsFg6ZOcdhqA35AsFOz0swaQJrPmvCmS5OQP7we5Eay3jI7VU3LVAJcCW4klJNwZmcAa4BKzpiLMRjdUENhiLXZcHHAQetSTy/f2WexdksZsflGuL3fQ/eEH/cxbO2nj+n+EM9NbGcyvjDW1ttwecro2mBnSZvg3oamX6ORm31NiHvQQLTeak91Ze4dlYbfcAG6sEn6qleAjMSHrTtYG/AO/wxmW7m5seAAAAAElFTkSuQmCC"
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">About us</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB70lEQVRIS7WVTYhPYRTGf4+RRIQ0SRNlo8SShWJkYzM1CxsLMWM3GylSvpViQSajZIkaZOMrq1nMNFmgWSkbC2VhYYGiFMWjo/dO93/d675/mXd1u/e8z+8573nPuWKOl+ZYn38C2F4M9Ej63GYwG2B7PXAEGABWJeGPwARwWdKLOlgWwHYIXwDmNzj+CVwEjkuK59lVC7C9EtgBLAQ2AUfbjiJ9vyrpYCPAdgBPASeABZmi1bABSU+Klx0Z2D4MXMoQfgbcAc4DUfDympG0+Q+A7TiO98DSDMCwpBu2p4D+mvg+Se/i/WwGtrcAzzPEI2RI0k3bk6lW1W0jkq5XAYeA0f8EiJt0IEz8zsD2SeBcpnhOBhHzDdgg29uBSHVeC+A1sAzorTmiGWBjutZlmSsBeAAMtoh/BVakDo7Cni3VYFrSGdvH0q0qS70KwKfkrO2E9koat70WWCdp0vYeSXdtL0ojY2tF5EMAoiA5I+MHsE/S7bJIEn8M7Kxx+CYAb4E1bfbT9w5Ii3hsuReAa8BIJiDCAjIMPATuNzgv5HYFoA94CSzvAlKAev6y55ak/UUfbEuOuoU06cecim7/Xh4Vq4HTwG4gxnW3KxrrKTAm6VGxuel/sCSj8aoGvlR/Nh2zqFu7ufE59z9XqzbuF7uUr0K7jjIuAAAAAElFTkSuQmCC); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB70lEQVRIS7WVTYhPYRTGf4+RRIQ0SRNlo8SShWJkYzM1CxsLMWM3GylSvpViQSajZIkaZOMrq1nMNFmgWSkbC2VhYYGiFMWjo/dO93/d675/mXd1u/e8z+8573nPuWKOl+ZYn38C2F4M9Ej63GYwG2B7PXAEGABWJeGPwARwWdKLOlgWwHYIXwDmNzj+CVwEjkuK59lVC7C9EtgBLAQ2AUfbjiJ9vyrpYCPAdgBPASeABZmi1bABSU+Klx0Z2D4MXMoQfgbcAc4DUfDympG0+Q+A7TiO98DSDMCwpBu2p4D+mvg+Se/i/WwGtrcAzzPEI2RI0k3bk6lW1W0jkq5XAYeA0f8EiJt0IEz8zsD2SeBcpnhOBhHzDdgg29uBSHVeC+A1sAzorTmiGWBjutZlmSsBeAAMtoh/BVakDo7Cni3VYFrSGdvH0q0qS70KwKfkrO2E9koat70WWCdp0vYeSXdtL0ojY2tF5EMAoiA5I+MHsE/S7bJIEn8M7Kxx+CYAb4E1bfbT9w5Ii3hsuReAa8BIJiDCAjIMPATuNzgv5HYFoA94CSzvAlKAev6y55ak/UUfbEuOuoU06cecim7/Xh4Vq4HTwG4gxnW3KxrrKTAm6VGxuel/sCSj8aoGvlR/Nh2zqFu7ufE59z9XqzbuF7uUr0K7jjIuAAAAAElFTkSuQmCC"
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">Download App</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox" onclick="window.location.href='/service'">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAACpklEQVRIS62WT4iNYRTGfw8Gs/CnrEZKjGxQxKyNnYVSMglRajJG/hULGwxFFggZY0azQWEysVBWwtpMiN0oTUkWUkjGNDw6t/eb7p357vUpZ3e/75znOe97nvN8V9QI2/XAZmAj0ATMT+kfgAHgAdAn6Wc1GFV7YXsrcK4MtFrqe+CIpLt5CZMIbE8BrgDtqeAFcA14DAynZ4uAdSlnZXp2Fdgv6Xc5UR5BJ7AX+AEcAHolOa+71Myu1NBMoEtS1I5HBYHtLcAdYARYL+mZ7SjcDewAlgNxwtfAbaBT0ojttcAjIGa2TVK8K8U4QQIaAhYArZJ6bS8EHibgvEO8ATZIGrbdClwHQgCNQTyRIDq8AbwEVgPTgec1wDPCIFkDjAKDwCpgp6SbEwn6gU1Am6Qe24eTimopOXt3UNJl23GV3UC/pJA3sn0IOAXMStlLJQ3ZDp3HSYrEgKQm243A21TwFTgRBF+A2WUodZLGbMfyxDUViRFJ9bbr0lVlNd+CoEKCkkqDtx0yDQUViVFJM1JdJV4NghhwDK9IDEoq5U7Csx13ld3/V0lzUmIs2aUi6Mkqzqe6Srw05JNpJ45LupgS48gx6FiuWlGSaWZ4k/BqVf7LolXDyfOisObTwFlJt2zHSfYB4a4rgDCz6DoWqTs6t70dOArEDdwvJyu3iqnJNWPlIwLoAtAh6Xteh7Zjdh1A7FJ4VETYRbukX/GjnKAL2JMD9DkZ4FPgXaoJj2oGovO5OTU9ktrGCWxH8pOCiima1hxunC1VH9BStLJg3j1JLRlBWGxDwcKiaR8lNWQEMZBsSEUB/pY3JqkuIwiLDav9XxEKPCPpWLmKlgDx6VsGLE5XNg8I64hPYezDtNRBnDjcNuQbbvwpfclCZa9CMJLi3wZ/AFlaC9dTSzvrAAAAAElFTkSuQmCC); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAACpklEQVRIS62WT4iNYRTGfw8Gs/CnrEZKjGxQxKyNnYVSMglRajJG/hULGwxFFggZY0azQWEysVBWwtpMiN0oTUkWUkjGNDw6t/eb7p357vUpZ3e/75znOe97nvN8V9QI2/XAZmAj0ATMT+kfgAHgAdAn6Wc1GFV7YXsrcK4MtFrqe+CIpLt5CZMIbE8BrgDtqeAFcA14DAynZ4uAdSlnZXp2Fdgv6Xc5UR5BJ7AX+AEcAHolOa+71Myu1NBMoEtS1I5HBYHtLcAdYARYL+mZ7SjcDewAlgNxwtfAbaBT0ojttcAjIGa2TVK8K8U4QQIaAhYArZJ6bS8EHibgvEO8ATZIGrbdClwHQgCNQTyRIDq8AbwEVgPTgec1wDPCIFkDjAKDwCpgp6SbEwn6gU1Am6Qe24eTimopOXt3UNJl23GV3UC/pJA3sn0IOAXMStlLJQ3ZDp3HSYrEgKQm243A21TwFTgRBF+A2WUodZLGbMfyxDUViRFJ9bbr0lVlNd+CoEKCkkqDtx0yDQUViVFJM1JdJV4NghhwDK9IDEoq5U7Csx13ld3/V0lzUmIs2aUi6Mkqzqe6Srw05JNpJ45LupgS48gx6FiuWlGSaWZ4k/BqVf7LolXDyfOisObTwFlJt2zHSfYB4a4rgDCz6DoWqTs6t70dOArEDdwvJyu3iqnJNWPlIwLoAtAh6Xteh7Zjdh1A7FJ4VETYRbukX/GjnKAL2JMD9DkZ4FPgXaoJj2oGovO5OTU9ktrGCWxH8pOCiima1hxunC1VH9BStLJg3j1JLRlBWGxDwcKiaR8lNWQEMZBsSEUB/pY3JqkuIwiLDav9XxEKPCPpWLmKlgDx6VsGLE5XNg8I64hPYezDtNRBnDjcNuQbbvwpfclCZa9CMJLi3wZ/AFlaC9dTSzvrAAAAAElFTkSuQmCC"
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">service</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox" onclick="window.location.href='/make'">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAChUlEQVRIS7WVS4iOYRTHf/8UY6HcNpRromyk5DZjpWmGCMVKygbJ/bJhIRKZDQuXsCC5LeQ6ClEu5S5JiWYWkiRJRGIiR//xftM773zv+03TOPUtvvd5nvM7zzn/cx7xn02d8R8RU4F5wDigP/AFeA40SrpZ5KMQEBFjgcNAdeLkE/ARGJj8/PkRsEzSs3KgXEBE1AFngV7AfuCApKaSk4gYBSwB1gABLJB0OQspC0gifwL8AGZKepiXhogYD1xKblQt6Wl6bx7gLjAJmCbpfqU6JRDvewFMkOQbtVoHQERMAe4BByUtTzuPiCpgG3A1W9yI2AOsBWol3SgC7AQ2ARMlPU7l3M7PA/XAT2CupGup9THAK2CvpNVFADuZDVRJ+u2NSeQl56Wz7SAR4Wx8BR5Iqi0CXAFqJPVJRbcO2F2mFp8luS9aLSI+AM2SaooAR4HFVoUk694HhwK3geEZyBZJ25M9vYFvwAVJ84sAS4FDwCJJJ1LRDQNupSBbJbngpejd6eeA9ZJc8FwV9QXeAsckrcyoyJDTwEVJDZk1i8OpHCnpfS4gua5Hga9r+yXpT5n8t/sUET2BfsB3YATQJKmltQ8iwpFZ//7fAowG5liqyWBz4U8C10vKygITpVmelriz8A6oU0TMcGEAR1DJrJLjwBFJL5PgHJSLusvpyTg4Y0AjMKuS5zLrdxLpbrSsc843GuDruzu72zwo6w3YB6zoZu8eIaskNRuwA9jcTYA3wAZJfkf+9UFEuAMXJlNycBdBTof7okGSZ1SbtY3rRMeTgemWl+c60KMC0HP/lKUpyc3ZwYqeTMvWDeP54z4ZAviGg4ABwGtLM+8tbktRF1PS6WN/ARV77NJrMPm8AAAAAElFTkSuQmCC); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAChUlEQVRIS7WVS4iOYRTHf/8UY6HcNpRromyk5DZjpWmGCMVKygbJ/bJhIRKZDQuXsCC5LeQ6ClEu5S5JiWYWkiRJRGIiR//xftM773zv+03TOPUtvvd5nvM7zzn/cx7xn02d8R8RU4F5wDigP/AFeA40SrpZ5KMQEBFjgcNAdeLkE/ARGJj8/PkRsEzSs3KgXEBE1AFngV7AfuCApKaSk4gYBSwB1gABLJB0OQspC0gifwL8AGZKepiXhogYD1xKblQt6Wl6bx7gLjAJmCbpfqU6JRDvewFMkOQbtVoHQERMAe4BByUtTzuPiCpgG3A1W9yI2AOsBWol3SgC7AQ2ARMlPU7l3M7PA/XAT2CupGup9THAK2CvpNVFADuZDVRJ+u2NSeQl56Wz7SAR4Wx8BR5Iqi0CXAFqJPVJRbcO2F2mFp8luS9aLSI+AM2SaooAR4HFVoUk694HhwK3geEZyBZJ25M9vYFvwAVJ84sAS4FDwCJJJ1LRDQNupSBbJbngpejd6eeA9ZJc8FwV9QXeAsckrcyoyJDTwEVJDZk1i8OpHCnpfS4gua5Hga9r+yXpT5n8t/sUET2BfsB3YATQJKmltQ8iwpFZ//7fAowG5liqyWBz4U8C10vKygITpVmelriz8A6oU0TMcGEAR1DJrJLjwBFJL5PgHJSLusvpyTg4Y0AjMKuS5zLrdxLpbrSsc843GuDruzu72zwo6w3YB6zoZu8eIaskNRuwA9jcTYA3wAZJfkf+9UFEuAMXJlNycBdBTof7okGSZ1SbtY3rRMeTgemWl+c60KMC0HP/lKUpyc3ZwYqeTMvWDeP54z4ZAviGg4ABwGtLM+8tbktRF1PS6WN/ARV77NJrMPm8AAAAAElFTkSuQmCC"
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">How to make money</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox" onclick="loogut()">
                                <uni-view data-v-1735120c="" class="left">
                                    <uni-view data-v-1735120c="">
                                        <uni-image data-v-1735120c="" style="height: 26px;">
                                            <div
                                                style="background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB1klEQVRIS72WTUtVURSGn3cgkWBIkfgFpQM/qNQgcKQ1E1IpRNFfIoKNBUdFNOgPhOIkQyQnkc6CQLylEk66QwNBBKFJsmTFFjbHffXc68eGzTmcvfd6zrvWOmsdmdkoMANsAFtAAdgEfks6IhpmVgt0Aw+APmAiWq6X9Cfe7/cys3FgPrsAHALbwM8wf/hV0p7vNbN24Fd07rak/RRgDFhIAEo92pXUkADUSjpIAV4Ai2UAkOTKswquHFAt6W9KwXNg+YIKPLjNkv6lAAPASoUAz7b3wCv3v5n9915sy31ZKeAu0CipYGY3gUlgX9LbLOAZ8LVcBSf7zWwYeAO0AlOSZrOAp8BquQAzqwHmgMHobBLQD6xVAMimqZtYAr5Etj57DHqBb5cEyJqZuBbAE+D7JSnwdI/j+ckVeHX0Spp7hFJxC/gADJ0X5IoAUZq+DGl6r1SadoayXK6CulAe1s2sGpgG9iS9zn4HqXQ7ExZVU+8X79y4pMNSpeIigJOGsyHpceqtPMjuu2Ju/3gbPN0PipJarhKwI8k9cWq4gobQc+/kVREU3Ac+hjP+gzCSBETp1gQ8ArrC7AHagKrsQQfkfpmzNprZDaAj/Ko8BBzaJak+L+AYPPXuCX5/YmMAAAAASUVORK5CYII=); background-size: 100% 100%; background-repeat: no-repeat;">
                                            </div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB1klEQVRIS72WTUtVURSGn3cgkWBIkfgFpQM/qNQgcKQ1E1IpRNFfIoKNBUdFNOgPhOIkQyQnkc6CQLylEk66QwNBBKFJsmTFFjbHffXc68eGzTmcvfd6zrvWOmsdmdkoMANsAFtAAdgEfks6IhpmVgt0Aw+APmAiWq6X9Cfe7/cys3FgPrsAHALbwM8wf/hV0p7vNbN24Fd07rak/RRgDFhIAEo92pXUkADUSjpIAV4Ai2UAkOTKswquHFAt6W9KwXNg+YIKPLjNkv6lAAPASoUAz7b3wCv3v5n9915sy31ZKeAu0CipYGY3gUlgX9LbLOAZ8LVcBSf7zWwYeAO0AlOSZrOAp8BquQAzqwHmgMHobBLQD6xVAMimqZtYAr5Etj57DHqBb5cEyJqZuBbAE+D7JSnwdI/j+ckVeHX0Spp7hFJxC/gADJ0X5IoAUZq+DGl6r1SadoayXK6CulAe1s2sGpgG9iS9zn4HqXQ7ExZVU+8X79y4pMNSpeIigJOGsyHpceqtPMjuu2Ju/3gbPN0PipJarhKwI8k9cWq4gobQc+/kVREU3Ac+hjP+gzCSBETp1gQ8ArrC7AHagKrsQQfkfpmzNprZDaAj/Ko8BBzaJak+L+AYPPXuCX5/YmMAAAAASUVORK5CYII="
                                                draggable="false">
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-1735120c="">Logout</uni-view>
                                </uni-view>
                            </uni-view>
                            <uni-view data-v-1735120c="" class="itemBox"></uni-view>
                        </uni-view>
                        <uni-view data-v-1735120c="" class="mask" style="display: none;"></uni-view>
                        <uni-view data-v-1735120c="" class="Card auto90" style="display: none;">
                            <uni-view data-v-1735120c="" class="d1 Bold">Kind reminder</uni-view>
                            <uni-view data-v-1735120c="" class="d2">You are performing an exit operation</uni-view>
                            <uni-view data-v-1735120c="" class="flexColumn">
                                <uni-view data-v-1735120c="" class="yes Medium">Confirm</uni-view>
                                <uni-view data-v-1735120c="" class="no Medium">Cancel</uni-view>
                            </uni-view>
                        </uni-view>
                        <uni-view data-v-1735120c="" class="status_bar"></uni-view>

                        @include('layouts.menu')
                    </uni-view>

                    <img class="loading" style="
                position: fixed;
                top: 50%;
                left: 50%;
                z-index: 9;
                width: 70px;
                display: block;
                transform: translate(-50%, -50%);" src="/public/static/1.gif" alt="">

                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>
    </uni-app>

    <script>
        window.onload = function () {
            document.querySelector('.loading').style.display = 'none';
        };

        function loogut() {
            document.querySelector('.loading').style.display = 'block';
            window.location.href = '/logout'
        }
    </script>

</body>
@endsection