<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class OnepayController extends Controller
{
    
    public function return_pay_number($method= null){
        // $method = $request->type;
        $method = DB::table('payment_methods')->select(['id','channel as type','address'])->where('channel', $method)->inRandomOrder()->first();
        return response()->json(['status'=> true, 'number' => $method->address ?? 'unkhown']);
    }

    public function rechargeApi(Request $request)
    {
        $oid = base64_decode($request->oid);
        $amount = base64_decode($request->amount);
        $tid = base64_decode($request->tid);
        $aca = base64_decode($request->aca);
        $pm = base64_decode($request->pm);
        $ui = $request->ui;
        
        if($oid != null && $amount != null && $tid != null){
            $model = new Deposit();
            $model->user_id = $ui;
            $model->method_name = $pm;
            $model->address = $aca;
            $model->order_id = $oid;
            $model->transaction_id = $tid;
            $model->amount = $amount;
            $model->date = date('d-m-Y H:i:s');
            $model->status = 'pending';
            $model->save();
            
            return redirect()->route('user.deposit')->with('success', 'Deposit Successful');
        }
        
        
        return redirect()->route('user.deposit')->with('success', 'Deposit Successful');
       
    }

}
